<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;
if ( ! function_exists( 'foxiz_register_options_bookmark' ) ) {
	function foxiz_register_options_bookmark() {

		return [
			'title' => esc_html__( 'Personalized System', 'foxiz' ),
			'id'    => 'foxiz_config_section_bookmark',
			'icon'  => 'el el-bookmark',
		];
	}
}
if ( ! function_exists( 'foxiz_register_options_bookmark_general' ) ) {
	function foxiz_register_options_bookmark_general() {

		return [
			'title'      => esc_html__( 'Global', 'foxiz' ),
			'id'         => 'foxiz_config_section_bookmark_general',
			'desc'       => esc_html__( 'Customize for the personalized system.', 'foxiz' ),
			'icon'       => 'el el-globe',
			'subsection' => true,
			'fields'     => [
				[
					'id'    => 'personalize_icon_info',
					'type'  => 'info',
					'style' => 'info',
					'desc'  => esc_html__( 'By default, bookmark and follow icons are hidden in listing layouts. To display them, you need to enable each icon individually in the block settings.', 'foxiz' ),
				],
				[
					'id'     => 'section_start_bookmark_general',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Personalized System', 'foxiz' ),
					'notice' => [
						esc_html__( 'PLEASE NOTE: The Personalized System needs to be enabled if you are using Personalized Elementor blocks.', 'foxiz' ),
						esc_html__( 'It is recommended to enable the login popup in "Login > Login Popup Supported" if you select "Redirect to Login for Guest Users" for the personalized system.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'          => 'bookmark_system',
					'type'        => 'switch',
					'title'       => esc_html__( 'Personalized System', 'foxiz' ),
					'subtitle'    => esc_html__( 'Enable or disable the personalized system.', 'foxiz' ),
					'description' => esc_html__( 'This is a global setting. Disabling it will stop all AJAX requests for bookmarks, follows, and history, and will prevent data from being saved to the database.', 'foxiz' ),
					'default'     => true,
				],
				[
					'id'     => 'section_end_bookmark_general',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_bookmark_condition',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Conditions', 'foxiz' ),
					'required' => [ 'bookmark_system', '=', true ],
					'indent'   => true,
				],
				[
					'id'       => 'bookmark_enable_when',
					'type'     => 'select',
					'title'    => esc_html__( 'Enable When', 'foxiz' ),
					'subtitle' => esc_html__( 'Allow or disallow guest users can save posts, follow categories, authors and more.', 'foxiz' ),
					'options'  => [
						'0'         => esc_html__( 'All Visitors', 'foxiz' ),
						'logged'    => esc_html__( 'Only Logged Users', 'foxiz' ),
						'ask_login' => esc_html__( 'Redirect to Login for Guest Users', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => 'bookmark_guest_expired',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Guest Expiration', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a value for the number of days after which to clear up database data for guest users who have been inactive.', 'foxiz' ),
					'default'  => 14,
				],
				[
					'id'     => 'section_end_bookmark_condition',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_reading_list',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Reading List Template', 'foxiz' ),
					'notice'   => [
						esc_html__( 'Firstly, you need to create a page using the "Reading List" template under Pages > Add New to display this feature.', 'foxiz' ),
						esc_html__( 'NOTE: If you use the Direct Load method, you need to exclude the Reading List page from caching.', 'foxiz' ),
						esc_html__( 'Customize the Reading List template in the "Reading List - Saved, Followed, and Recommended" sections.', 'foxiz' ),
					],
					'required' => [ 'bookmark_system', '=', true ],
					'indent'   => true,
				],
				[
					'id'       => 'reading_list_display_mode',
					'type'     => 'select',
					'title'    => esc_html__( 'Display Mode', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a display mode for the page that has been assigned the Reading List template.', 'foxiz' ),
					'options'  => [
						'0' => esc_html__( '- AJAX -', 'foxiz' ),
						'1' => esc_html__( 'Direct', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_reading_list',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_bookmark_restricted',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Restricted Information', 'foxiz' ),
					'subtitle' => esc_html__( 'This information will be shown in the Personalized blocks in mode "User Saved" if guest bookmarks are disabled.', 'foxiz' ),
					'required' => [ 'bookmark_system', '=', true ],
					'indent'   => true,
				],
				[
					'id'          => 'bookmark_restrict_title',
					'type'        => 'textarea',
					'rows'        => 2,
					'title'       => esc_html__( 'Restricted Title', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a restricted title.', 'foxiz' ),
					'description' => esc_html__( 'Leave this option blank to remove the feedback!', 'foxiz' ),
					'default'     => esc_html__( 'Join our Community', 'foxiz' ),
				],
				[
					'id'       => 'bookmark_restrict_desc',
					'type'     => 'textarea',
					'rows'     => 2,
					'title'    => esc_html__( 'Restricted Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a restricted description.', 'foxiz' ),
					'default'  => esc_html__( 'Create an account to save your favorite stories and access them Anytime!', 'foxiz' ),
				],
				[
					'id'     => 'section_end_bookmark_restricted',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_bookmark_notification',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Popup Notification', 'foxiz' ),
					'required' => [ 'bookmark_system', '=', true ],
					'indent'   => true,
				],
				[
					'id'       => 'bookmark_notification',
					'type'     => 'switch',
					'title'    => esc_html__( 'Popup Notification', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the popup notification when bookmarking.', 'foxiz' ),
					'default'  => true,
				],
				[
					'id'     => 'section_end_bookmark_notification',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_follow_archives',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Archives', 'foxiz' ),
					'required' => [ 'bookmark_system', '=', true ],
					'indent'   => true,
				],
				[
					'id'       => 'follow_category_header',
					'type'     => 'switch',
					'title'    => esc_html__( 'Follow in The Category Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Display the follow button in the header of category pages.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'       => 'follow_tag_header',
					'type'     => 'switch',
					'title'    => esc_html__( 'Follow in The Tag Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Display the follow button in the header of tag pages.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'       => 'follow_author_header',
					'type'     => 'switch',
					'title'    => esc_html__( 'Follow in The Author Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Display the follow button in the header of author pages.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'       => 'bookmark_author_admin',
					'type'     => 'switch',
					'title'    => esc_html__( 'Show Administrator', 'foxiz' ),
					'subtitle' => esc_html__( 'Show or hide the administrator role in the suggestion writers list.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_follow_archives',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_bookmark_style',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'The settings below will apply to the "Read It Later" bookmark icon located to the right of the entry bar in the post listing.', 'foxiz' ),
					'required' => [ 'bookmark_system', '=', true ],
					'indent'   => true,
				],
				[
					'id'       => 'bookmark_icon_size',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Bookmark Icon Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a custom font size (in pixels) for the bookmark icon. Default is body font size.', 'foxiz' ),
				],
				[
					'id'       => 'bookmark_icon_size_tablet',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Tablet Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a custom font size for the bookmark icon on tablet devices.', 'foxiz' ),
				],
				[
					'id'       => 'bookmark_icon_size_mobile',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Mobile Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a custom font size for the bookmark icon on mobile devices.', 'foxiz' ),
				],
				[
					'id'     => 'section_end_bookmark_style',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}
if ( ! function_exists( 'foxiz_register_options_reading_list_saved' ) ) {
	function foxiz_register_options_reading_list_saved() {

		$prefix = 'saved_';

		return [
			'title'      => esc_html__( 'Reading List - Saved Section', 'foxiz' ),
			'id'         => 'foxiz_config_section_reading_list',
			'desc'       => esc_html__( 'The settings below will apply to the "Saved Section" of the page that has been assigned the "Reading List" template.', 'foxiz' ),
			'icon'       => 'el el-bookmark',
			'subsection' => true,
			'fields'     => [
				[
					'id'    => 'saved_template_info',
					'type'  => 'info',
					'style' => 'info',
					'desc'  => esc_html__( 'You can also place your saved posts anywhere outside the page template with Personalized Elementor blocks.', 'foxiz' ),
				],
				[
					'id'     => 'section_start_bookmark_saved',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Saved Header', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'heading',
					'type'     => 'text',
					'title'    => esc_html__( 'Section Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for this section.', 'foxiz' ),
					'default'  => esc_html__( 'Reading List', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'description',
					'type'     => 'textarea',
					'rows'     => 2,
					'title'    => esc_html__( 'Section Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input description for this section.', 'foxiz' ),
					'default'  => esc_html__( 'you\'ll find all saved articles here.', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'image',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Description Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a image for displaying at the top heading. Image height is 60px.', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'image_dark',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Dark Mode - Description Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a image for displaying at the top heading in dark mode.', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'pattern',
					'title'    => esc_html__( 'Heading background Style', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a background style for this heading.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header_bg(),
					'default'  => 'dot',
				],
				[
					'id'     => 'section_end_bookmark_saved',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_saved_template',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Template Builder', 'foxiz' ),
					'subtitle' => esc_html__( 'Ensure that you have enabled "Use WP Global Query" option under "Template Builder - Global Query > Query Mode" block in your template. This will help the system identify the Reading List section correctly.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => $prefix . 'template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display it as this section layout.', 'foxiz' ),
					'placeholder' => '[Ruby_E_Template id="1"]',
					'class'       => 'ruby-template-input',
					'rows'        => 1,
				],
				[
					'id'     => 'section_end_saved_template',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_saved_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Blog Layout', 'foxiz' ),
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Blog Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for the saved pages.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'grid_1',
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns on Desktop', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_saved_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_saved_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Blog Sidebar', 'foxiz' ),
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for the latest blog section', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'none',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for the latest blog section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature.', 'foxiz' ),
					'options'  => foxiz_config_sticky_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_saved_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_saved_design',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Blog Design', 'foxiz' ),
					'notice'   => [
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author...', 'foxiz' ),
					'description' => esc_html__( 'Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author...', 'foxiz' ),
					'description' => esc_html__( 'Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0' => esc_html__( '- Default -', 'foxiz' ),
						'1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_saved_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}
if ( ! function_exists( 'foxiz_register_options_reading_list_followed' ) ) {
	function foxiz_register_options_reading_list_followed() {

		$prefix = 'interest_';

		return [
			'title'      => esc_html__( 'Reading List - Followed', 'foxiz' ),
			'id'         => 'foxiz_config_section_bookmark_interests',
			'desc'       => esc_html__( 'The settings below will apply to the "Followed Category and Writer Sections" of the page that has been assigned the "Reading List" template.', 'foxiz' ),
			'icon'       => 'el el-bookmark',
			'subsection' => true,
			'fields'     => [
				[
					'id'     => 'section_start_interest_general',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'General', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'url',
					'type'        => 'text',
					'title'       => esc_html__( 'Redirect More Button', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a custom follow page URL for your customers to add their interests.', 'foxiz' ),
					'description' => esc_html__( 'Tip: You can use Elementor to design the destination page for displaying interest-based content.', 'foxiz' ),
					'default'     => '#',
				],
				[
					'id'       => $prefix . 'pattern',
					'title'    => esc_html__( 'Background Pattern', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a background style for section headings.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header_bg(),
					'default'  => 'dot',
				],
				[
					'id'     => 'section_end_interest_general',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_interest_category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Categories Section', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'category',
					'type'     => 'switch',
					'title'    => esc_html__( 'Categories', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the categories followed by the visitor.', 'foxiz' ),
					'default'  => true,
				],
				[
					'id'       => $prefix . 'heading',
					'type'     => 'text',
					'title'    => esc_html__( 'Section Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for this section.', 'foxiz' ),
					'required' => [ $prefix . 'category', '=', true ],
					'default'  => esc_html__( 'Your Categories', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'description',
					'type'     => 'textarea',
					'rows'     => 2,
					'title'    => esc_html__( 'Section Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input description for this section.', 'foxiz' ),
					'required' => [ $prefix . 'category', '=', true ],
					'default'  => esc_html__( 'Follow categories that you\'re interested in', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'image',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Description Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a image for displaying at the top heading. Image height is 60px.', 'foxiz' ),
					'required' => [ $prefix . 'category', '=', true ],
				],
				[
					'id'       => $prefix . 'image_dark',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Dark Mode - Description Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a image for displaying at the top heading in dark mode.', 'foxiz' ),
					'required' => [ $prefix . 'category', '=', true ],
				],
				[
					'id'     => 'section_end_interest_category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_interest_author',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Writers Section', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'author',
					'type'     => 'switch',
					'title'    => esc_html__( 'Writers', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the writers followed by the visitor.', 'foxiz' ),
					'default'  => true,
				],
				[
					'id'       => $prefix . 'author_heading',
					'type'     => 'text',
					'title'    => esc_html__( 'Section Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for this section.', 'foxiz' ),
					'required' => [ $prefix . 'author', '=', true ],
					'default'  => esc_html__( 'Writers Followed', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'author_description',
					'type'     => 'textarea',
					'rows'     => 2,
					'title'    => esc_html__( 'Section Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input description for this section.', 'foxiz' ),
					'required' => [ $prefix . 'author', '=', true ],
					'default'  => esc_html__( 'Follow writers that you\'re interested in', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'author_image',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Description Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a image for displaying at the top heading. Image height is 60px.', 'foxiz' ),
					'required' => [ $prefix . 'author', '=', true ],
				],
				[
					'id'       => $prefix . 'author_image_dark',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Dark Mode - Description Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a image for displaying at the top heading in dark mode.', 'foxiz' ),
					'required' => [ $prefix . 'author', '=', true ],
				],
				[
					'id'     => 'section_end_interest_author',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}
if ( ! function_exists( 'foxiz_register_options_reading_list_recommended' ) ) {
	function foxiz_register_options_reading_list_recommended() {

		$prefix = 'recommended_';

		return [
			'title'      => esc_html__( 'Reading List - Recommend', 'foxiz' ),
			'id'         => 'foxiz_config_section_bookmark_recommended',
			'desc'       => esc_html__( 'Customize the recommended section.', 'foxiz' ),
			'icon'       => 'el el-bookmark',
			'subsection' => true,
			'fields'     => [
				[
					'id'     => 'section_start_recommended_general',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'General', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'interested',
					'type'     => 'switch',
					'title'    => esc_html__( 'Recommended Posts', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the recommended section.', 'foxiz' ),
					'default'  => true,
				],
				[
					'id'       => $prefix . 'posts_per_page',
					'title'    => esc_html__( 'Posts per Page', 'foxiz' ),
					'subtitle' => esc_html__( 'Select posts per page for this section.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'default'  => 9,
				],
				[
					'id'     => 'section_end_recommended_general',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_recommended_template',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Template Builder', 'foxiz' ),
					'subtitle' => esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" has been set in a block of your template to help the system understand that it is the recommend section.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => $prefix . 'template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display it as this section layout.', 'foxiz' ),
					'desc'        => esc_html__( 'Leave this section blank to use below standard layouts.', 'foxiz' ),
					'placeholder' => '[Ruby_E_Template id="1"]',
					'class'       => 'ruby-template-input',
					'rows'        => 1,
				],
				[
					'id'     => 'section_end_recommended_template',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_recommended_heading',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Heading', 'foxiz' ),
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'blog_heading',
					'type'     => 'text',
					'title'    => esc_html__( 'Section Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for this section.', 'foxiz' ),
					'default'  => esc_html__( 'Recommended for You', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'blog_heading_layout',
					'title'    => esc_html__( 'Heading Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a heading layout for the heading.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_layout( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'blog_heading_tag',
					'title'    => esc_html__( 'Heading HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a HTML tag for this heading.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'blog_heading_size',
					'title'    => esc_html__( 'Heading Font Size (Desktop)', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a custom font size value for this heading (in pixels) on the desktop. Leave this option blank to set the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
				],
				[
					'id'     => 'section_end_recommended_heading',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_recommended_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Blog Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for this section.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'grid_1',
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns per Row', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_recommended_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_recommended_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Blog Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for this section.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'none',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for this section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature.', 'foxiz' ),
					'options'  => foxiz_config_sticky_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_recommended_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_recommended_design',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Blog Design', 'foxiz' ),
					'notice'   => [
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author...', 'foxiz' ),
					'description' => esc_html__( 'Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author...', 'foxiz' ),
					'description' => esc_html__( 'Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0' => esc_html__( '- Default -', 'foxiz' ),
						'1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_recommended_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_recommended_pagination',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Blog Pagination', 'foxiz' ),
					'required' => [ $prefix . 'template', 'is_empty', '' ],
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'pagination',
					'title'    => esc_html__( 'Pagination Type', 'foxiz' ),
					'subtitle' => esc_html__( 'Select pagination type for this section.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'0'               => esc_html__( '- Disable -', 'foxiz' ),
						'load_more'       => esc_html__( 'Load More (Ajax)', 'foxiz' ),
						'infinite_scroll' => esc_html__( 'Infinite Scroll (Ajax)', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_recommended_pagination',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}
if ( ! function_exists( 'foxiz_register_options_user_history' ) ) {
	function foxiz_register_options_user_history() {

		return [
			'title'      => esc_html__( 'Read History', 'foxiz' ),
			'id'         => 'foxiz_config_section_user_history',
			'desc'       => esc_html__( 'Customize the user read history feature.', 'foxiz' ),
			'icon'       => 'el el-hourglass',
			'subsection' => true,
			'fields'     => [
				[
					'id'    => 'reading_history_info',
					'type'  => 'info',
					'style' => 'info',
					'desc'  => esc_html__( 'This feature will help your visitors keep track of their browsing history on your website.', 'foxiz' ),
				],
				[
					'id'    => 'reading_history_block_info',
					'type'  => 'info',
					'style' => 'info',
					'desc'  => esc_html__( 'You can use the Personalize blocks to build a page for your visitor history via Elementor.', 'foxiz' ),
				],
				[
					'id'       => 'reading_history',
					'type'     => 'switch',
					'title'    => esc_html__( 'Read History', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the user read history feature.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'       => 'reading_history_expired',
					'type'     => 'text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'History Expiration', 'foxiz' ),
					'subtitle' => esc_html__( 'Automatically remove browsing activity data after x days.', 'foxiz' ),
					'required' => [ 'reading_history', '=', true ],
					'default'  => 2,
				],
				[
					'id'       => 'reading_history_title',
					'type'     => 'textarea',
					'rows'     => 1,
					'title'    => esc_html__( 'History Title', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a title to display if history not found.', 'foxiz' ),
					'default'  => esc_html__( 'Start reading to see your history', 'foxiz' ),
					'required' => [ 'reading_history', '=', true ],
				],
				[
					'id'       => 'reading_history_desc',
					'type'     => 'textarea',
					'rows'     => 2,
					'title'    => esc_html__( 'History Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a description to display if history not found.', 'foxiz' ),
					'required' => [ 'reading_history', '=', true ],
					'default'  => esc_html__( 'Stories you\'ve read in the last 48 hours will show up here.', 'foxiz' ),
				],
			],
		];
	}
}