<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'foxiz_theme_options_default_values' ) ) {
	function foxiz_theme_options_default_values() {
		return [
			'header_style'                         => '1',
			'menu_hover_effect'                    => '1',
			'hd1_nav_style'                        => 'shadow',
			'hd1_header_socials'                   => true,
			'hd4_header_socials'                   => true,
			'dark_hd4_background'                  => [
				'from' => '#191c20',
			],
			'hd5_nav_style'                        => 'border',
			'hd5_header_socials'                   => true,
			'dark_hd5_background'                  => [
				'from' => '#191c20',
			],
			'mobile_search'                        => true,
			'mobile_amp_search'                    => true,
			'mh_divider'                           => 'shadow',
			'mh_top_divider'                       => 'gray',
			'mobile_search_form'                   => true,
			'mobile_social'                        => true,
			'more_column'                          => '3',
			'header_search_heading'                => 'Search',
			'header_search_icon'                   => true,
			'header_search_mode'                   => 'search',
			'more_search'                          => true,
			'header_login_menu_mobile'             => true,
			'notification_duration'                => 72,
			'notification_reload'                  => 12,
			'header_notification_url'              => '#',
			'alert_home'                           => true,
			'alert_url'                            => '#',
			'global_sidebar_position'              => 'right',
			'footer_background'                    => [
				'background-color' => '#88888812',
			],
			'footer_layout'                        => '5',
			'footer_logo_socials'                  => true,
			'max_post_tags'                        => '1',
			'meta_divider'                         => 'default',
			'meta_tax_style'                       => '1',
			'meta_tag_important'                   => true,
			'meta_view_pretty_number'              => true,
			'read_speed'                           => 130,
			'edit_post_link'                       => true,
			'meta_custom_pos'                      => 'end',
			'meta_custom_fallback'                 => 'update',
			'crop_position'                        => 'top',
			'edit_link'                            => true,
			'foxiz_crop_g1'                        => true,
			'foxiz_crop_g2'                        => true,
			'foxiz_crop_g3'                        => true,
			'foxiz_crop_o1'                        => true,
			'foxiz_crop_o2'                        => true,
			'slider_play'                          => true,
			'slider_fmode'                         => true,
			'post_icon_video'                      => true,
			'live_label'                           => 'Live: ',
			'live_blog_meta'                       => 'dot',
			'single_post_live_label'               => 'Live Updates',
			'live_blog_interval'                   => '600',
			'readmore_icon'                        => true,
			'hover_effect'                         => '1',
			'btn_hover_effect'                     => '1',
			'btn_hover_ani'                        => '1',
			'svg_supported'                        => true,
			'gif_supported'                        => '1',
			'back_top'                             => true,
			'site_tooltips'                        => true,
			'loader_style'                         => '1',
			'classic_1_entry_category'             => 'bg-1,big',
			'classic_1_entry_meta'                 => [
				'avatar',
				'author',
				'update',
			],
			'classic_1_review'                     => '1',
			'classic_1_review_meta'                => '1',
			'classic_1_sponsor_meta'               => true,
			'classic_1_entry_format'               => 'bottom,big',
			'classic_1_excerpt_length'             => 30,
			'classic_1_excerpt_source'             => 'tagline',
			'grid_1_entry_category'                => 'bg-1',
			'grid_1_entry_meta'                    => [
				'avatar',
				'author',
				'update',
			],
			'grid_1_review'                        => 'replace',
			'grid_1_review_meta'                   => '1',
			'grid_1_sponsor_meta'                  => true,
			'grid_1_entry_format'                  => 'bottom',
			'grid_1_excerpt_length'                => 12,
			'grid_2_entry_category'                => 'bg-1',
			'grid_2_entry_meta'                    => [
				'avatar',
				'author',
				'update',
			],
			'grid_2_review'                        => 'replace',
			'grid_2_review_meta'                   => '1',
			'grid_2_sponsor_meta'                  => true,
			'grid_2_entry_format'                  => 'bottom',
			'grid_2_excerpt_length'                => 12,
			'grid_small_1_entry_category'          => 'bg-1',
			'grid_small_1_hide_category'           => 'mobile',
			'grid_small_1_entry_meta'              => [
				'update',
			],
			'grid_small_1_review'                  => 'replace',
			'grid_small_1_review_meta'             => '-1',
			'grid_small_1_sponsor_meta'            => true,
			'grid_small_1_entry_format'            => 'bottom',
			'grid_box_1_box_style'                 => 'bg',
			'grid_box_1_entry_category'            => 'bg-1,big',
			'grid_box_1_entry_meta'                => [
				'avatar',
				'author',
				'update',
			],
			'grid_box_1_review'                    => 'replace',
			'grid_box_1_review_meta'               => '1',
			'grid_box_1_sponsor_meta'              => true,
			'grid_box_1_entry_format'              => 'bottom',
			'grid_box_1_excerpt_length'            => 12,
			'grid_box_2_box_style'                 => 'bg',
			'grid_box_2_entry_category'            => 'bg-1',
			'grid_box_2_entry_meta'                => [
				'avatar',
				'author',
				'update',
			],
			'grid_box_2_review'                    => 'replace',
			'grid_box_2_review_meta'               => '1',
			'grid_box_2_sponsor_meta'              => true,
			'grid_box_2_entry_format'              => 'bottom',
			'grid_box_2_excerpt_length'            => 12,
			'list_1_featured_position'             => 'right',
			'list_1_entry_category'                => 'bg-1',
			'list_1_entry_meta'                    => [
				'avatar',
				'author',
				'update',
			],
			'list_1_review'                        => 'replace',
			'list_1_review_meta'                   => '1',
			'list_1_sponsor_meta'                  => true,
			'list_1_entry_format'                  => 'bottom',
			'list_1_excerpt_length'                => 12,
			'list_1_excerpt_source'                => 'tagline',
			'list_2_featured_position'             => 'right',
			'list_2_entry_category'                => 'bg-1',
			'list_2_entry_meta'                    => [
				'avatar',
				'author',
				'update',
			],
			'list_2_review'                        => 'replace',
			'list_2_review_meta'                   => '1',
			'list_2_sponsor_meta'                  => true,
			'list_2_entry_format'                  => 'bottom',
			'list_2_excerpt_length'                => 20,
			'list_2_excerpt_source'                => 'tagline',
			'list_box_1_box_style'                 => 'bg',
			'list_box_1_featured_position'         => 'right',
			'list_box_1_entry_category'            => 'bg-1',
			'list_box_1_entry_meta'                => [
				'avatar',
				'author',
				'update',
			],
			'list_box_1_review'                    => 'replace',
			'list_box_1_review_meta'               => '1',
			'list_box_1_sponsor_meta'              => true,
			'list_box_1_entry_format'              => 'bottom',
			'list_box_1_excerpt_length'            => 12,
			'list_box_1_excerpt_source'            => 'tagline',
			'list_box_2_box_style'                 => 'bg',
			'list_box_2_featured_position'         => 'right',
			'list_box_2_entry_category'            => 'bg-1',
			'list_box_2_entry_meta'                => [
				'avatar',
				'author',
				'update',
			],
			'list_box_2_review'                    => 'replace',
			'list_box_2_review_meta'               => '1',
			'list_box_2_sponsor_meta'              => true,
			'list_box_2_entry_format'              => 'bottom',
			'list_box_2_excerpt_length'            => 12,
			'list_box_2_excerpt_source'            => 'tagline',
			'heading_layout'                       => '1',
			'footer_widget_heading_layout'         => '10',
			'single_post_layout'                   => 'standard_1',
			'single_post_video_layout'             => 'video_1',
			'single_post_video_float'              => true,
			'single_post_audio_layout'             => 'audio_1',
			'single_post_gallery_layout'           => 'gallery_1',
			'single_post_gallery_lightbox'         => 1,
			'single_10_ratio'                      => '45',
			'single_11_ratio'                      => '45',
			'single_post_featured_lightbox'        => true,
			'auto_video_featured'                  => true,
			'single_post_line_length'              => '1',
			'single_content_width'                 => '760',
			'single_post_width_wo_sb'              => 'small',
			'single_content_fw_width'              => '840',
			'hyperlink_line'                       => '1',
			'single_post_quick_view'               => true,
			'single_post_tags'                     => true,
			'single_post_sources'                  => true,
			'single_post_via'                      => true,
			'single_post_newsletter_title'         => 'Sign Up For Daily Newsletter',
			'single_post_newsletter_description'   => 'Be keep up! Get the latest breaking news delivered straight to your inbox.',
			'single_post_newsletter_code'          => '[mc4wp_form]',
			'single_post_newsletter_policy'        => 'By signing up, you agree to our <a href=\'#\'>Terms of Use<\/a> and acknowledge the data practices in our <a href=\'#\'>Privacy Policy<\/a>. You may unsubscribe at any time.',
			'single_post_author_card'              => true,
			'share_left'                           => true,
			'share_left_mobile'                    => true,
			'share_left_color'                     => true,
			'share_left_facebook'                  => true,
			'share_left_twitter'                   => true,
			'share_left_copy'                      => true,
			'share_left_print'                     => true,
			'share_left_native'                    => true,
			'single_post_sidebar_name'             => 'foxiz_sidebar_default',
			'single_post_sidebar_position'         => 'default',
			'tagline_tag'                          => 'h2',
			'highlight_heading'                    => 'Highlights',
			'highlight_layout'                     => '1',
			'single_post_entry_category'           => 'bg-1,big',
			'single_post_entry_meta'               => [
				'author',
			],
			'single_post_avatar'                   => true,
			'single_post_meta_date_label'          => true,
			'single_post_author_job'               => true,
			'single_post_updated_meta'             => true,
			'single_post_updated_label'            => true,
			'single_post_min_read'                 => true,
			'share_top'                            => true,
			'share_top_color'                      => true,
			'share_top_facebook'                   => true,
			'share_top_twitter'                    => true,
			'share_top_copy'                       => true,
			'share_top_print'                      => true,
			'share_top_native'                     => true,
			'sponsor_meta_text'                    => 'Sponsored by',
			'sponsor_meta_icon'                    => true,
			'disclosure_content'                   => '<strong>Disclosure:<\/strong> This website may contain affiliate links, which means I may earn a commission if you click on the link and make a purchase. I only recommend products or services that I personally use and believe will add value to my readers. Your support is appreciated!',
			'disclosure_layout'                    => 'text',
			'single_post_review_type'              => 'star',
			'single_post_review_stuff_cols'        => '2',
			'single_post_related'                  => 'standard',
			'single_post_related_where'            => 'all',
			'single_post_related_order'            => 'rand',
			'single_post_related_total'            => 4,
			'single_post_related_blog_heading'     => 'You Might Also Like',
			'single_post_related_layout'           => 'grid_small_1',
			'single_post_inline_related_pos'       => '5',
			'single_post_ajax_limit'               => 20,
			'ajax_next_button'                     => true,
			'ajax_next_sidebar_name'               => 'foxiz_sidebar_default',
			'ajax_next_hide_sidebar'               => true,
			'ajax_next_comment_button'             => true,
			'share_bottom'                         => true,
			'share_bottom_color'                   => true,
			'share_bottom_facebook'                => true,
			'share_bottom_twitter'                 => true,
			'share_bottom_copy'                    => true,
			'share_bottom_print'                   => true,
			'share_bottom_native'                  => true,
			'share_sticky'                         => true,
			'share_sticky_label'                   => true,
			'share_sticky_facebook'                => true,
			'share_sticky_twitter'                 => true,
			'share_sticky_copy'                    => true,
			'share_sticky_print'                   => true,
			'share_sticky_native'                  => true,
			'single_post_reading_indicator'        => true,
			'single_post_highlight_share_facebook' => true,
			'single_post_highlight_share_twitter'  => true,
			'single_post_highlight_share_reddit'   => true,
			'single_font_resizer'                  => true,
			'post_type_layout'                     => 'standard_8',
			'post_type_layout_video'               => 'default',
			'single_video_sidebar_name'            => 'default',
			'page_page_header_style'               => '1',
			'page_width_wo_sb'                     => 'small',
			'page_sidebar_position'                => 'none',
			'page_sidebar_name'                    => 'foxiz_sidebar_default',
			'category_entry_tag'                   => true,
			'category_category_header'             => '1',
			'category_pattern'                     => 'dot',
			'category_subcategory'                 => true,
			'category_template_display'            => '1',
			'category_layout'                      => 'grid_1',
			'category_blog_heading'                => 'Latest {archive} News',
			'category_sidebar_position'            => 'none',
			'category_sidebar_name'                => 'foxiz_sidebar_default',
			'category_excerpt_source'              => 'tagline',
			'category_pagination'                  => 'number',
			'blog_template_display'                => '1',
			'blog_layout'                          => 'classic_1',
			'blog_sidebar_position'                => 'default',
			'blog_sidebar_name'                    => 'foxiz_sidebar_default',
			'blog_excerpt_source'                  => 'tagline',
			'blog_pagination'                      => 'number',
			'author_bio'                           => true,
			'author_count'                         => true,
			'author_pattern'                       => 'dot',
			'author_tick'                          => true,
			'author_layout'                        => 'grid_1',
			'author_sidebar_position'              => 'none',
			'author_sidebar_name'                  => 'foxiz_sidebar_default',
			'author_excerpt_source'                => 'tagline',
			'author_pagination'                    => 'number',
			'search_type_disallow'                 => 'page, attachment, e-landing-page',
			'search_post_types'                    => 'post, podcast',
			'search_header_background'             => [
				'background-size'       => 'cover',
				'background-attachment' => 'scroll',
				'background-position'   => 'center center',
				'background-repeat'     => 'no-repeat',
			],
			'dark_search_header_background'        => [
				'background-size'       => 'cover',
				'background-attachment' => 'scroll',
				'background-position'   => 'center center',
				'background-repeat'     => 'no-repeat',
			],
			'search_layout'                        => 'grid_small_1',
			'search_sidebar_position'              => 'none',
			'search_sidebar_name'                  => 'foxiz_sidebar_default',
			'search_excerpt_source'                => 'tagline',
			'search_pagination'                    => 'number',
			'tag_template_display'                 => '1',
			'archive_archive_header'               => '1',
			'archive_pattern'                      => 'dot',
			'archive_layout'                       => 'grid_1',
			'archive_sidebar_position'             => 'none',
			'archive_sidebar_name'                 => 'foxiz_sidebar_default',
			'archive_excerpt_source'               => 'tagline',
			'archive_pagination'                   => 'number',
			'page_404_search'                      => true,
			'table_contents_post_types'            => 'post, podcast',
			'table_contents_h2'                    => true,
			'table_contents_h3'                    => true,
			'table_contents_h4'                    => false,
			'table_contents_h5'                    => false,
			'table_contents_h6'                    => false,
			'table_contents_layout'                => '1',
			'table_contents_enable'                => 2,
			'table_contents_heading'               => 'Contents',
			'table_contents_position'              => 1,
			'table_contents_hierarchy'             => true,
			'table_contents_numlist'               => true,
			'table_contents_scroll'                => true,
			'table_contents_toggle'                => true,
			'reaction_guest_expired'               => 14,
			'reaction_logged_expired'              => 14,
			'reaction_items'                       => [
				'enabled'  => [
					'love'   => 'Love',
					'sad'    => 'Sad',
					'happy'  => 'Happy',
					'sleepy' => 'Sleepy',
					'angry'  => 'Angry',
					'dead'   => 'Dead',
					'wink'   => 'Wink',
				],
				'disabled' => [
					'cry'       => 'Cry',
					'embarrass' => 'Embarrass',
					'joy'       => 'Joy',
					'shy'       => 'Shy',
					'surprise'  => 'Surprise',
				],
			],
			'bookmark_system'                      => true,
			'bookmark_guest_expired'               => 14,
			'bookmark_restrict_title'              => 'Join our Community',
			'bookmark_restrict_desc'               => 'Create an account to save your favorite stories and access them Anytime!',
			'bookmark_notification'                => true,
			'saved_heading'                        => 'Reading List',
			'saved_description'                    => 'you&#039;ll find all saved articles here.',
			'saved_pattern'                        => 'dot',
			'saved_layout'                         => 'grid_1',
			'saved_sidebar_position'               => 'none',
			'saved_sidebar_name'                   => 'foxiz_sidebar_default',
			'saved_excerpt_source'                 => 'tagline',
			'interest_url'                         => '#',
			'interest_pattern'                     => 'dot',
			'interest_category'                    => true,
			'interest_heading'                     => 'Your Categories',
			'interest_description'                 => 'Follow categories that you&#039;re interested in',
			'interest_author'                      => true,
			'interest_author_heading'              => 'Writers Followed',
			'interest_author_description'          => 'Follow writers that you&#039;re interested in',
			'recommended_interested'               => true,
			'recommended_posts_per_page'           => 9,
			'recommended_blog_heading'             => 'Recommended for You',
			'recommended_layout'                   => 'grid_1',
			'recommended_sidebar_position'         => 'none',
			'recommended_sidebar_name'             => 'foxiz_sidebar_default',
			'recommended_excerpt_source'           => 'tagline',
			'reading_history_expired'              => 2,
			'reading_history_title'                => 'Start reading to see your history',
			'reading_history_desc'                 => 'Stories you&#039;ve read in the last 48 hours will show up here.',
			'facebook'                             => '#',
			'twitter'                              => '#',
			'breadcrumb'                           => true,
			'single_post_breadcrumb'               => '1',
			'category_breadcrumb'                  => '1',
			'author_breadcrumb'                    => '1',
			'archive_breadcrumb'                   => '1',
			'privacy_text'                         => 'By using this site, you agree to the <a href=\'#\'>Privacy Policy<\/a> and <a href=\'#\'>Terms of Use<\/a>.',
			'privacy_position'                     => 'left',
			'privacy_width'                        => 'wrap',
			'dark_mode_cookie'                     => '2',
			'first_visit_mode'                     => 'default',
			'dark_mode_style'                      => '1',
			'newsletter_title'                     => 'Join Us!',
			'newsletter_description'               => 'Subscribe to our newsletter and never miss our latest news, podcasts etc.',
			'newsletter_shortcode'                 => '[mc4wp_form]',
			'newsletter_footer'                    => 'Zero spam, Unsubscribe at any time.',
			'newsletter_popup_expired'             => '1',
			'newsletter_popup_display'             => 'scroll',
			'newsletter_popup_offset'              => '2000',
			'lazy_load'                            => true,
			'disable_srcset'                       => true,
			'lazy_load_content'                    => true,
			'disable_dashicons'                    => true,
			'preload_gfonts'                       => true,
			'preload_font_icon'                    => true,
			'organization_markup'                  => true,
			'website_markup'                       => true,
			'site_itemlist'                        => true,
			'website_description'                  => true,
			'limit_archive_description'            => true,
			'single_post_article_markup'           => '1',
			'single_post_review_markup'            => true,
			'single_post_live_markup'              => true,
			'open_graph'                           => true,
			'front_page_h1'                        => true,
			'adblock_title'                        => 'AdBlock Detected',
			'adblock_description'                  => 'Our site is an advertising supported site. Please whitelist to support our site.',
			'disable_ad_auto_wc'                   => true,
			'ad_top_type'                          => '1',
			'ad_top_desktop_size'                  => '1',
			'ad_top_tablet_size'                   => '2',
			'ad_top_mobile_size'                   => '3',
			'ad_top_destination'                   => '#',
			'ad_top_padding'                       => '15',
			'ad_single_type'                       => '1',
			'ad_single_description'                => '- Advertisement -',
			'ad_single_align'                      => 'full',
			'ad_single_positions'                  => 4,
			'ad_single_desktop_size'               => '1',
			'ad_single_tablet_size'                => '2',
			'ad_single_mobile_size'                => '3',
			'ad_single_destination'                => '#',
			'ad_single_2_type'                     => '1',
			'ad_single_2_description'              => '- Advertisement -',
			'ad_single_2_align'                    => 'full',
			'ad_single_2_positions'                => 9,
			'ad_single_2_desktop_size'             => '1',
			'ad_single_2_tablet_size'              => '2',
			'ad_single_2_mobile_size'              => '3',
			'ad_single_2_destination'              => '#',
			'ad_single_3_type'                     => '1',
			'ad_single_3_description'              => '- Advertisement -',
			'ad_single_3_align'                    => 'full',
			'ad_single_3_positions'                => 12,
			'ad_single_3_desktop_size'             => '1',
			'ad_single_3_tablet_size'              => '2',
			'ad_single_3_mobile_size'              => '3',
			'ad_single_3_destination'              => '#',
			'slide_up_expired'                     => '1',
			'header_login_heading'                 => 'Welcome Back!',
			'header_login_description'             => 'Sign in to your account',
			'login_popup_width'                    => '350',
			'login_screen_bg'                      => [
				'background-size'       => 'cover',
				'background-attachment' => 'fixed',
				'background-repeat'     => 'no-repeat',
				'background-position'   => 'center center',
			],
			'login_page_disable_logged'            => true,
			'remove_admin_bar'                     => true,
			'podcast_blog_included'                => true,
			'podcast_author_included'              => true,
			'podcast_tag_included'                 => true,
			'podcast_meta_play_label'              => true,
			'podcast_meta_duration_label'          => true,
			'podcast_inline_ad'                    => true,
			'single_podcast_markup'                => true,
			'podcast_socials_overlay'              => true,
			'podcast_readmore_label'               => 'View Episode',
			'single_podcast_layout'                => '1',
			'single_podcast_entry_category'        => 'bg-1,big',
			'single_podcast_avatar'                => true,
			'single_podcast_entry_meta'            => [
				'author',
				'index',
			],
			'single_podcast_author_job'            => true,
			'single_podcast_meta_date_label'       => true,
			'single_podcast_updated_meta'          => true,
			'single_podcast_min_read'              => true,
			'single_podcast_sidebar_name'          => 'foxiz_sidebar_default',
			'single_podcast_sidebar_position'      => 'default',
			'single_podcast_breadcrumb'            => '1',
			'series_category_header'               => '2',
			'series_pattern'                       => 'dot',
			'series_rss'                           => true,
			'podcast_archive_pattern'              => 'dot',
			'remove_amp_switcher'                  => true,
			'amp_copyright'                        => true,
			'amp_back_top'                         => true,
			'amp_disable_left_share'               => true,
			'amp_disable_single_sidebar'           => true,
			'amp_header_ad_type'                   => '1',
			'amp_header_adsense_size'              => '1',
			'amp_footer_ad_type'                   => '1',
			'amp_footer_adsense_size'              => '1',
			'amp_top_single_ad_type'               => '1',
			'amp_top_single_adsense_size'          => '1',
			'amp_bottom_single_ad_type'            => '1',
			'amp_bottom_single_adsense_size'       => '1',
			'amp_inline_single_ad_type'            => '1',
			'amp_inline_single_adsense_size'       => '1',
			'amp_ad_single_positions'              => '4',
			'redux-backup'                         => '1',
		];
	}
}